﻿var editRoleGroups = {
    datatable: null,
    context: $(".v-editRoleGroups"),
    initializeDataTable: function () {
        var isSystemRole = $("#IsSystemRole", editRoleGroups.context).val() == "True";

        this.datatable = $(".h-groupsTable").a4datatable({
            ajaxAction: a4.getAction("GetGroups", "Users", "Settings"),
            ajaxParams: { "multiModeOnly": true },
            columns: [
                { "Name": "Id", "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name }
            ],
            allowRowSelection: function (data) { return true || !isSystemRole || !data.IsSystemGroup; },
            rememberRowSelection: true,
            selectedRows: $("#GroupIds").val()
        });
    },

    bindEvents: function () {
        $(document).on("click", ".v-confirmButton", function () {
            var items = editRoleGroups.datatable.a4datatable("getSelectedItems");
            var groupIds = _.pluck(items, "Id").join(",");
            var roleId = $("#RoleId").val();

            a4.callServerMethod(a4.getAction("UpdateRoleGroups", "Users", "Settings"), { roleId: roleId, groupIds: groupIds },
            function (result) {
                modalDialog.close();
            });
        });
    }
}

$(document).ready(function () {
    if (editRoleGroups.context.length > 0) {
        editRoleGroups.initializeDataTable();
        editRoleGroups.bindEvents();
    }
});